/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.client.hud;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import gloridifice.watersource.common.tile.WaterFilterDownTile;
import gloridifice.watersource.common.tile.WaterFilterUpTile;
import gloridifice.watersource.registry.BlockRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="watersource")
public class WaterFilterStrainerHUD
extends AbstractGui {
    int animeTime = 0;
    protected Minecraft mc;

    public WaterFilterStrainerHUD(Minecraft mc) {
        this.mc = mc;
    }

    public void render(MatrixStack matrixStack, BlockPos bpos) {
        TileEntity tile = bpos != null ? this.mc.field_71441_e.func_175625_s(bpos) : null;
        IProfiler profiler = this.mc.func_213239_aq();
        if (tile == null) {
            this.animeTime -= this.animeTime > 0 ? 1 : 0;
        } else if (tile instanceof WaterFilterUpTile) {
            profiler.func_76320_a("waterFilterStrainer");
            this.renderWaterFilterStrainer(matrixStack, tile);
            profiler.func_76319_b();
        } else if (tile instanceof WaterFilterDownTile) {
            profiler.func_76320_a("waterFilterStrainer");
            this.renderWaterFilterStrainer(matrixStack, this.mc.field_71441_e.func_175625_s(bpos.func_177984_a()));
            profiler.func_76319_b();
        }
    }

    private void renderWaterFilterStrainer(MatrixStack matrixStack, TileEntity tile) {
        if (tile == null) {
            return;
        }
        ItemStack stack = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(data -> data.getStackInSlot(0)).orElse(ItemStack.field_190927_a);
        if (stack.func_190926_b()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        float scale = 1.3f;
        int x = 10;
        int y = mc.func_228018_at_().func_198087_p() / 2;
        RenderSystem.pushMatrix();
        RenderSystem.enableRescaleNormal();
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        RenderSystem.enableBlend();
        mc.func_175599_af().func_175042_a(stack, x, (int)((float)(y - 16) / scale));
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
        String text = I18n.func_135052_a((String)"watersource.misc.damage", (Object[])new Object[0]) + " " + (stack.func_77958_k() - stack.func_77952_i()) + "/" + stack.func_77958_k();
        if (stack.func_77973_b() == BlockRegistry.ITEM_DIRTY_STRAINER) {
            text = I18n.func_135052_a((String)"watersource.misc.dirty_strainer", (Object[])new Object[0]);
        }
        fontRenderer.func_238421_b_(matrixStack, text, (float)(x + 4), (float)(y + 6), 0xFFFFFF);
        RenderSystem.popMatrix();
    }
}

